package com.ejie.p06b.dec;

import java.util.ArrayList;

import com.ejie.p06b.datatype.logic.P06BDECModelos12jun2010;
import com.ejie.p06b.datatype.logic.P06BDECTotales12jun2010;
import com.ejie.p06b.datatype.model.P06B32T00Datatype;
import com.ejie.p06b.datatype.model.P06B36T00Datatype;
import com.ejie.p06b.datatype.model.P06B37T00Datatype;
import com.ejie.p06b.datatype.model.P06B38T00Datatype;
import com.ejie.p06b.datatype.model.P06B39T00Datatype;
import com.ejie.p06b.datatype.model.P06B45T00Datatype;
import com.ejie.p06b.datatype.model.P06B46T00Datatype;
import com.ejie.p06b.datatype.model.P06B47T00Datatype;
import com.ejie.p06b.datatype.model.P06B48T00Datatype;
import com.ejie.p06b.datatype.model.P06B49T00Datatype;
import com.ejie.p06b.datatype.model.P06B50T00Datatype;
import com.ejie.p06b.datatype.model.P06B51T00Datatype;
import com.ejie.p06b.datatype.model.P06B52T00Datatype;
import com.ejie.p06b.datatype.model.P06B53T00Datatype;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BUtil;


/**
 * 
 * Calcula los totales y campos calculados de la DEC a partir del decreto de 12 junio 2010
 * 
 * Fecha de creacin: (10/02/2012)
 */
public class P06BCalcTotDEC {
	
	
	public static P06BDECTotales12jun2010 calcTotalesDEC(P06BDECModelos12jun2010 objDECModelos) throws Exception {
		
		P06BDECTotales12jun2010 objTotales = new P06BDECTotales12jun2010();
		try{
			if(objDECModelos != null){
				P06B32T00Datatype mod01y02 = objDECModelos.getMod01y02();
				ArrayList listaMod02Socios = objDECModelos.getListaMod02Socios();
				ArrayList listaMod02Cargos = objDECModelos.getListaMod02Cargos();
				P06B45T00Datatype obj45Mod1SedeProf = objDECModelos.getObj45Mod1SedeProf();
				ArrayList listaMod1MedPer = objDECModelos.getListaMod1MedPer();
				P06B37T00Datatype mod21 = objDECModelos.getMod21();
				ArrayList listaMod22 = objDECModelos.getListaMod22();
				P06B39T00Datatype mod23 = objDECModelos.getMod23();
				ArrayList listaObjs43Mod0EntVinc = objDECModelos.getListaObjs43Mod0EntVinc();
				ArrayList listaObjs44Mod0EntCred = objDECModelos.getListaObjs44Mod0EntCred();
				ArrayList listaObjs46Mod1Sucur = objDECModelos.getListaObjs46Mod1Sucur();
				ArrayList listaObjs47Mod21PrimPorEnt = objDECModelos.getListaObjs47Mod21PrimPorEnt();
				P06B48T00Datatype obj48Mod3InverValorAnad = objDECModelos.getObj48Mod3InverValorAnad();
				P06B53T00Datatype obj53Mod3Vinc = objDECModelos.getObj53Mod3Vinc();
				P06B49T00Datatype obj49Mod31 = objDECModelos.getObj49Mod31();
				P06B50T00Datatype obj50Mod32 = objDECModelos.getObj50Mod32();
				P06B51T00Datatype obj51Mod33Activo = objDECModelos.getObj51Mod33Activo();
				P06B52T00Datatype obj52Mod33Pasivo = objDECModelos.getObj52Mod33Pasivo();
				ArrayList listaJustifAdjuntosDEC = objDECModelos.getJustifAdjuntos();
				
		
				if(mod01y02 == null)
					mod01y02 = new P06B32T00Datatype();
				
				if(listaMod02Socios == null)
					listaMod02Socios = new ArrayList();
					
				if(listaMod02Cargos == null)	
					listaMod02Cargos = new ArrayList();
					
				if(obj45Mod1SedeProf == null)
					obj45Mod1SedeProf = new P06B45T00Datatype();
				
				if(listaMod1MedPer == null)
					listaMod1MedPer = new ArrayList();
					
				if(mod21 == null)
					mod21 = new P06B37T00Datatype();
					
				if(listaMod22 == null)
					listaMod22 = new ArrayList();
					
				if(mod23 == null)
					mod23 = new P06B39T00Datatype();
				
				if(listaObjs43Mod0EntVinc == null)
					listaObjs43Mod0EntVinc = new ArrayList();
					
				if(listaObjs44Mod0EntCred == null)
					listaObjs44Mod0EntCred = new ArrayList();
		
				if(listaObjs46Mod1Sucur == null)
					listaObjs46Mod1Sucur = new ArrayList();
		
				if(listaObjs47Mod21PrimPorEnt == null)
					listaObjs47Mod21PrimPorEnt = new ArrayList();
		
				if(obj48Mod3InverValorAnad == null)
					obj48Mod3InverValorAnad = new P06B48T00Datatype();
				
				if(obj53Mod3Vinc == null)
					obj53Mod3Vinc = new P06B53T00Datatype();
		
				if(obj49Mod31 == null)
					obj49Mod31 = new P06B49T00Datatype();
		
				if(obj50Mod32 == null)
					obj50Mod32 = new P06B50T00Datatype();
		
				if(obj51Mod33Activo == null)
					obj51Mod33Activo = new P06B51T00Datatype();
		
				if(obj52Mod33Pasivo == null)
					obj52Mod33Pasivo = new P06B52T00Datatype();
					
				if(listaJustifAdjuntosDEC == null)
					listaJustifAdjuntosDEC = new ArrayList();
										
				
				//--------- CAMPOS CALCULADOS ---------
				//Calcular el total de la pestaa de Calculo Valor Aadido
				double totalValorAnad = 0.0;
				totalValorAnad = P06BUtil.redondear((P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadComis()) 
					+ P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadSubv())
					+ P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadOtrosIng())
					- P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadCompras())
					- P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadServExt())
					- P06BUtil.convertDouble(obj48Mod3InverValorAnad.getValorAnadOtrosTrib())),2);
				objTotales.setTotalValorAnad(totalValorAnad);
				
				//Calcular los totales del Modelo 3 VINCULADOS
				double totalIngrActMod3Vinc = 0.0;
				double totalGastActMod3Vinc = 0.0;
				double totalIngMenosGastMod3Vinc = 0.0;
				double totalCtaTotMod3Vinc = 0.0;
				totalIngrActMod3Vinc = P06BUtil.redondear((P06BUtil.convertDouble(obj53Mod3Vinc.getIngrComis()) 
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getIngrFinanc())
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getIngrOtros())),2);
				totalGastActMod3Vinc = P06BUtil.redondear((P06BUtil.convertDouble(obj53Mod3Vinc.getGastCostesPer()) 
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getGastComisAuxExt())
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getGastFormacion())
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getGastFinanc())
					+ P06BUtil.convertDouble(obj53Mod3Vinc.getGastOtros())),2);
				totalIngMenosGastMod3Vinc = P06BUtil.redondear((totalIngrActMod3Vinc - totalGastActMod3Vinc),2);
				totalCtaTotMod3Vinc = P06BUtil.redondear((P06BUtil.convertDouble(obj53Mod3Vinc.getCtaIngrTotal()) 
					- P06BUtil.convertDouble(obj53Mod3Vinc.getCtaGastTotal())),2);
				objTotales.setTotalIngrActMod3Vinc(totalIngrActMod3Vinc);
				objTotales.setTotalGastActMod3Vinc(totalGastActMod3Vinc);
				objTotales.setTotalIngMenosGastMod3Vinc(totalIngMenosGastMod3Vinc);
				objTotales.setTotalCtaTotMod3Vinc(totalCtaTotMod3Vinc);
				
				//Calcular los totales del Modelo 3.1 (fsicas)
				double totalImpNetAfecMod31 = 0.0;
				double totalImpNetMod31 = 0.0;
				double totalOtrosIngMod31 = 0.0;
				double totalGastPerMod31 = 0.0;
				double totalOtrosGastMod31 = 0.0;
				double totalIngFinanMod31 = 0.0;
				double totalGastFinanMod31 = 0.0;
				double totalMod31 = 0.0;
				totalImpNetAfecMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getImpNetoAfecComis()) 
					+ P06BUtil.convertDouble(obj49Mod31.getImpNetoAfecHonor())),2);
				totalImpNetMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getImpNetoAfecComis()) 
					+ P06BUtil.convertDouble(obj49Mod31.getImpNetoAfecHonor())
					+ P06BUtil.convertDouble(obj49Mod31.getImpNetoResto())),2);
				totalOtrosIngMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getIngrOtrosAfec()) 
					+ P06BUtil.convertDouble(obj49Mod31.getIngrOtrosResto())),2);
				totalGastPerMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getGastPerAfec()) 
					+ P06BUtil.convertDouble(obj49Mod31.getGastPerResto())),2);
				totalOtrosGastMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getGastOtrosAfec()) 
					+ P06BUtil.convertDouble(obj49Mod31.getGastOtrosResto())),2);
				totalIngFinanMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getIngrFinancAfec()) 
					+ P06BUtil.convertDouble(obj49Mod31.getIngrFinancResto())),2);
				totalGastFinanMod31 = P06BUtil.redondear((P06BUtil.convertDouble(obj49Mod31.getGastFinancAfec()) 
					+ P06BUtil.convertDouble(obj49Mod31.getGastFinancResto())),2);
				totalMod31 = P06BUtil.redondear((totalImpNetMod31 + totalOtrosIngMod31 - totalGastPerMod31 
										- totalOtrosGastMod31 + totalIngFinanMod31 - totalGastFinanMod31),2);
				objTotales.setTotalImpNetAfecMod31(totalImpNetAfecMod31);
				objTotales.setTotalImpNetMod31(totalImpNetMod31);
				objTotales.setTotalOtrosIngMod31(totalOtrosIngMod31);
				objTotales.setTotalGastPerMod31(totalGastPerMod31);
				objTotales.setTotalOtrosGastMod31(totalOtrosGastMod31);
				objTotales.setTotalIngFinanMod31(totalIngFinanMod31);
				objTotales.setTotalGastFinanMod31(totalGastFinanMod31);
				objTotales.setTotalMod31(totalMod31);
				
				//Calcular los totales del Modelo 3.2 (jurdicas)
				double totalImpNetAfecMod32 = 0.0;
				double totalImpNetMod32 = 0.0;
				double totalOtrosIngMod32 = 0.0;
				double totalGastPerMod32 = 0.0;
				double totalOtrosGastMod32 = 0.0;
				
				double totalResulExplotMod32 = 0.0;
				double totalResulFinanMod32 = 0.0;
				double totalResulAntImpuesMod32 = 0.0;
				double totalResulEjerMod32 = 0.0;
				
				totalImpNetAfecMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getImpNetoAfecComis()) 
					+ P06BUtil.convertDouble(obj50Mod32.getImpNetoAfecHonor())),2);
				totalImpNetMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getImpNetoAfecComis()) 
					+ P06BUtil.convertDouble(obj50Mod32.getImpNetoAfecHonor())
					+ P06BUtil.convertDouble(obj50Mod32.getImpNetoResto())),2);
				totalOtrosIngMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getIngrOtrosAfec()) 
					+ P06BUtil.convertDouble(obj50Mod32.getIngrOtrosResto())),2);
				totalGastPerMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getGastPerAfec()) 
					+ P06BUtil.convertDouble(obj50Mod32.getGastPerResto())),2);
				totalOtrosGastMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getGastOtrosAfec()) 
					+ P06BUtil.convertDouble(obj50Mod32.getGastOtrosResto())),2);
				
				totalResulExplotMod32 = P06BUtil.redondear((totalImpNetMod32 
												+ P06BUtil.convertDouble(obj50Mod32.getVariacProduc()) 
												+ P06BUtil.convertDouble(obj50Mod32.getTrabAct()) 
												+ P06BUtil.convertDouble(obj50Mod32.getAprov()) 
												+ totalOtrosIngMod32 
												+ totalGastPerMod32 
												+ totalOtrosGastMod32 
												+ P06BUtil.convertDouble(obj50Mod32.getAmort()) 
												+ P06BUtil.convertDouble(obj50Mod32.getImputSubv()) 
												+ P06BUtil.convertDouble(obj50Mod32.getExcesoProv()) 
												+ P06BUtil.convertDouble(obj50Mod32.getEnajInmov())),2);
				totalResulFinanMod32 = P06BUtil.redondear((P06BUtil.convertDouble(obj50Mod32.getIngrFinanc()) 
												+ P06BUtil.convertDouble(obj50Mod32.getGastFinanc()) 
												+ P06BUtil.convertDouble(obj50Mod32.getVariacInstrFinanc()) 
												+ P06BUtil.convertDouble(obj50Mod32.getDiferCambio()) 
												+ P06BUtil.convertDouble(obj50Mod32.getEnajInstrFinanc())),2);
				totalResulAntImpuesMod32 = P06BUtil.redondear((totalResulExplotMod32 + totalResulFinanMod32),2);
				totalResulEjerMod32 = P06BUtil.redondear((totalResulAntImpuesMod32 
												+ P06BUtil.convertDouble(obj50Mod32.getImpuesBenef())),2);
				
				objTotales.setTotalImpNetAfecMod32(totalImpNetAfecMod32);
				objTotales.setTotalImpNetMod32(totalImpNetMod32);
				objTotales.setTotalOtrosIngMod32(totalOtrosIngMod32);
				objTotales.setTotalGastPerMod32(totalGastPerMod32);
				objTotales.setTotalOtrosGastMod32(totalOtrosGastMod32);
				
				objTotales.setTotalResulExplotMod32(totalResulExplotMod32);
				objTotales.setTotalResulFinanMod32(totalResulFinanMod32);
				objTotales.setTotalResulAntImpuesMod32(totalResulAntImpuesMod32);
				objTotales.setTotalResulEjerMod32(totalResulEjerMod32);
				
				//Calcular los totales del Modelo 3.3 (jurdicas)
				double totalActNoCorrMod33Act = 0.0;
				double totalActCorrDeudMod33Act = 0.0;
				double totalActCorrMod33Act = 0.0;
				double totalActMod33Act = 0.0;
				
				double totalNetoMod33Pas = 0.0;
				double totalNetoPropMod33Pas = 0.0;
				double totalNetoPropCapMod33Pas = 0.0;
				double totalPasNoCorrMod33Pas = 0.0;
				double totalPasNoCorrDeudMod33Pas = 0.0;
				double totalPasCorrMod33Pas = 0.0;
				double totalPasCorrDeudMod33Pas = 0.0;
				double totalPasCorrAcreedMod33Pas = 0.0;
				double totalNetoYPasivoMod33Pas = 0.0;
				
				totalActNoCorrMod33Act = P06BUtil.redondear((P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrInmovIntang()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrInmovMat()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrInverInmob())
												+ P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrInverEmp()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrInverFinanc()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getNoCorrImpuesDif())),2);		
				totalActCorrDeudMod33Act = P06BUtil.redondear((P06BUtil.convertDouble(obj51Mod33Activo.getCorrDeudClientes()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrDeudAccionis())  
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrDeudOtros())),2);
				totalActCorrMod33Act = P06BUtil.redondear((P06BUtil.convertDouble(obj51Mod33Activo.getCorrNoCorr()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrExist()) 
												+ totalActCorrDeudMod33Act  
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrInverEmp()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrInverFinanc()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrPeriodif()) 
												+ P06BUtil.convertDouble(obj51Mod33Activo.getCorrEfect())),2);
				totalActMod33Act = P06BUtil.redondear((totalActNoCorrMod33Act + totalActCorrMod33Act),2);
				
				totalNetoPropCapMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropCapEscr()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropCapNoExig())),2);		
				totalNetoPropMod33Pas = P06BUtil.redondear((totalNetoPropCapMod33Pas 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropPrimEmis()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropReser()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropAccion()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropResEjerAnt()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropOtrasApor()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropResEjer()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropDividen()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoPropOtrosInstr())),2);
				totalNetoMod33Pas = P06BUtil.redondear((totalNetoPropMod33Pas 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoAjusCam()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNetoSubv())),2);
				totalPasNoCorrDeudMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrDeudCred()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrDeudArren())  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrDeudOtras())),2);						
				totalPasNoCorrMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrProv()) 
												+ totalPasNoCorrDeudMod33Pas  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrDeudEmp())  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrImpuesDif()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getNoCorrPeriodif())),2);
				totalPasCorrDeudMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrDeudCred()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrDeudArren())  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrDeudOtras())),2);
				totalPasCorrAcreedMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrProveed()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrOtrosAcreed())),2);
				totalPasCorrMod33Pas = P06BUtil.redondear((P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrNoCorr()) 
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrProv())  
												+ totalPasCorrDeudMod33Pas  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrDeudEmp())  
												+ totalPasCorrAcreedMod33Pas  
												+ P06BUtil.convertDouble(obj52Mod33Pasivo.getCorrPeriodif())),2);
				totalNetoYPasivoMod33Pas = P06BUtil.redondear((totalNetoMod33Pas + totalPasNoCorrMod33Pas + totalPasCorrMod33Pas),2);
				
				objTotales.setTotalActNoCorrMod33Act(totalActNoCorrMod33Act);
				objTotales.setTotalActCorrDeudMod33Act(totalActCorrDeudMod33Act);
				objTotales.setTotalActCorrMod33Act(totalActCorrMod33Act);
				objTotales.setTotalActMod33Act(totalActMod33Act);
				
				objTotales.setTotalNetoMod33Pas(totalNetoMod33Pas);
				objTotales.setTotalNetoPropMod33Pas(totalNetoPropMod33Pas);
				objTotales.setTotalNetoPropCapMod33Pas(totalNetoPropCapMod33Pas);
				objTotales.setTotalPasNoCorrMod33Pas(totalPasNoCorrMod33Pas);
				objTotales.setTotalPasNoCorrDeudMod33Pas(totalPasNoCorrDeudMod33Pas);
				objTotales.setTotalPasCorrMod33Pas(totalPasCorrMod33Pas);
				objTotales.setTotalPasCorrDeudMod33Pas(totalPasCorrDeudMod33Pas);
				objTotales.setTotalPasCorrAcreedMod33Pas(totalPasCorrAcreedMod33Pas);
				objTotales.setTotalNetoYPasivoMod33Pas(totalNetoYPasivoMod33Pas);
				
				
				//Calcular los totales y porcentajes del Modelo 2.3
				double totPrimInterVolTotMod23 = 0.0;
				double totComisDevenVolTotMod23 = 0.0;
				double totHonorProfVolTotMod23 = 0.0;
				double porcPrimVolTotIndMod23 = 0.0;
				double porcPrimVolTotColMod23 = 0.0;
				
				double totPrimInterNuevaMod23 = 0.0;
				double totComisDevenNuevaMod23 = 0.0;
				double totHonorProfNuevaMod23 = 0.0;
				double porcPrimNuevaIndMod23 = 0.0;
				double porcPrimNuevaColMod23 = 0.0;
				
				totPrimInterVolTotMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getVolTotIndPrimInter()) 
					+ P06BUtil.convertDouble(mod23.getVolTotColPrimInter())),2);
				totComisDevenVolTotMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getVolTotIndComisDeven()) 
					+ P06BUtil.convertDouble(mod23.getVolTotColComisDeven())),2);
				totHonorProfVolTotMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getVolTotIndHonorProf()) 
					+ P06BUtil.convertDouble(mod23.getVolTotColHonorProf())),2);
				if(totPrimInterVolTotMod23 != 0.0){
					porcPrimVolTotIndMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getVolTotIndPrimInter()) * 100 / totPrimInterVolTotMod23),2);
					porcPrimVolTotColMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getVolTotColPrimInter()) * 100 / totPrimInterVolTotMod23),2);
				}
				
				totPrimInterNuevaMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getNuevaIndPrimInter()) 
					+ P06BUtil.convertDouble(mod23.getNuevaColPrimInter())),2);
				totComisDevenNuevaMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getNuevaIndComisDeven()) 
					+ P06BUtil.convertDouble(mod23.getNuevaColComisDeven())),2);
				totHonorProfNuevaMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getNuevaIndHonorProf()) 
					+ P06BUtil.convertDouble(mod23.getNuevaColHonorProf())),2);
				if(totPrimInterNuevaMod23 != 0.0){
					porcPrimNuevaIndMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getNuevaIndPrimInter()) * 100 / totPrimInterNuevaMod23),2);
					porcPrimNuevaColMod23 = P06BUtil.redondear((P06BUtil.convertDouble(mod23.getNuevaColPrimInter()) * 100 / totPrimInterNuevaMod23),2);
				}
				
				objTotales.setTotPrimInterVolTotMod23(totPrimInterVolTotMod23);
				objTotales.setTotComisDevenVolTotMod23(totComisDevenVolTotMod23);
				objTotales.setTotHonorProfVolTotMod23(totHonorProfVolTotMod23);
				objTotales.setPorcPrimVolTotIndMod23(porcPrimVolTotIndMod23);
				objTotales.setPorcPrimVolTotColMod23(porcPrimVolTotColMod23);
				
				objTotales.setTotPrimInterNuevaMod23(totPrimInterNuevaMod23);
				objTotales.setTotComisDevenNuevaMod23(totComisDevenNuevaMod23);
				objTotales.setTotHonorProfNuevaMod23(totHonorProfNuevaMod23);
				objTotales.setPorcPrimNuevaIndMod23(porcPrimNuevaIndMod23);
				objTotales.setPorcPrimNuevaColMod23(porcPrimNuevaColMod23);
				
				
				//Calcular los totales y porcentajes del Modelo 2.2
				double totPrimInterVolTotMod22 = 0.0;
				double totComisDevenVolTotMod22 = 0.0;
				double totHonorProfVolTotMod22 = 0.0;
				
				double totPrimInterNuevaMod22 = 0.0;
				double totComisDevenNuevaMod22 = 0.0;
				double totHonorProfNuevaMod22 = 0.0;
				
				for(int i=0;i<listaMod22.size();i++){
		    		P06B38T00Datatype objMod22 = (P06B38T00Datatype)listaMod22.get(i);
		    		
		    		totPrimInterVolTotMod22 += P06BUtil.convertDouble(objMod22.getVolTotPrimInter());
		    		totComisDevenVolTotMod22 += P06BUtil.convertDouble(objMod22.getVolTotComisDeven());
					totHonorProfVolTotMod22 += P06BUtil.convertDouble(objMod22.getVolTotHonorProf());
				
					totPrimInterNuevaMod22 += P06BUtil.convertDouble(objMod22.getNuevaPrimInter());
					totComisDevenNuevaMod22 += P06BUtil.convertDouble(objMod22.getNuevaComisDeven());
					totHonorProfNuevaMod22 += P06BUtil.convertDouble(objMod22.getNuevaHonorProf());
		    	}
		    	
		    	totPrimInterVolTotMod22 = P06BUtil.redondear(totPrimInterVolTotMod22, 2);
		    	totComisDevenVolTotMod22 = P06BUtil.redondear(totComisDevenVolTotMod22, 2);
		    	totHonorProfVolTotMod22 = P06BUtil.redondear(totHonorProfVolTotMod22, 2);
		    	totPrimInterNuevaMod22 = P06BUtil.redondear(totPrimInterNuevaMod22, 2);
		    	totComisDevenNuevaMod22 = P06BUtil.redondear(totComisDevenNuevaMod22, 2);
		    	totHonorProfNuevaMod22 = P06BUtil.redondear(totHonorProfNuevaMod22, 2);
		    	
		    	objTotales.setTotPrimInterVolTotMod22(totPrimInterVolTotMod22);
		    	objTotales.setTotComisDevenVolTotMod22(totComisDevenVolTotMod22);
		    	objTotales.setTotHonorProfVolTotMod22(totHonorProfVolTotMod22);
		    	objTotales.setTotPrimInterNuevaMod22(totPrimInterNuevaMod22);
		    	objTotales.setTotComisDevenNuevaMod22(totComisDevenNuevaMod22);
		    	objTotales.setTotHonorProfNuevaMod22(totHonorProfNuevaMod22);
				
				
				//Calcular los campos del Modelo 2.1
				double primInterVolTotMod21 = 0.0;
				double porcVidaVolTotMod21 = 0.0;
				double porcNoVidaVolTotMod21 = 0.0;
				double redPropiaVolTotMod21 = 0.0;
				
				double primInterNuevaMod21 = 0.0;
				double porcVidaNuevaMod21 = 0.0;
				double porcNoVidaNuevaMod21 = 0.0;
				double redPropiaNuevaMod21 = 0.0;
				
				primInterVolTotMod21 = P06BUtil.redondear(totPrimInterVolTotMod22 + totPrimInterVolTotMod23,2);
				if(primInterVolTotMod21 != 0.0){
					porcVidaVolTotMod21 = P06BUtil.redondear((totPrimInterVolTotMod23 * 100 / primInterVolTotMod21),2);
					porcNoVidaVolTotMod21 = P06BUtil.redondear((totPrimInterVolTotMod22 * 100 / primInterVolTotMod21),2);
				}
				redPropiaVolTotMod21 = P06BUtil.redondear((primInterVolTotMod21 - P06BUtil.convertDouble(mod21.getVolTotExtAux()) - P06BUtil.convertDouble(mod21.getVolTotExtOtros())),2);
				
				primInterNuevaMod21 = P06BUtil.redondear(totPrimInterNuevaMod22 + totPrimInterNuevaMod23,2);
				if(primInterNuevaMod21 != 0.0){
					porcVidaNuevaMod21 = P06BUtil.redondear((totPrimInterNuevaMod23 * 100 / primInterNuevaMod21),2);
					porcNoVidaNuevaMod21 = P06BUtil.redondear((totPrimInterNuevaMod22 * 100 / primInterNuevaMod21),2);
				}
				redPropiaNuevaMod21 = P06BUtil.redondear((primInterNuevaMod21 - P06BUtil.convertDouble(mod21.getNuevaExtAux()) - P06BUtil.convertDouble(mod21.getNuevaExtOtros())),2);
		
				//Calcular los totales del apartado volumen total de negocio por entidad aseguradora del Modelo 2.1
				double totPrimEntVolTotMod21 = 0.0;
				double totPrimEntNuevaMod21 = 0.0;
				for(int i=0;i<listaObjs47Mod21PrimPorEnt.size();i++){
		    		P06B47T00Datatype objMod21 = (P06B47T00Datatype)listaObjs47Mod21PrimPorEnt.get(i);
		    		
		    		totPrimEntVolTotMod21 += P06BUtil.convertDouble(objMod21.getVoltotPrimas());
		    		totPrimEntNuevaMod21 += P06BUtil.convertDouble(objMod21.getNuevaPrimas());
		    	}
		    	totPrimEntVolTotMod21 = P06BUtil.redondear(totPrimEntVolTotMod21, 2);
		    	totPrimEntNuevaMod21 = P06BUtil.redondear(totPrimEntNuevaMod21, 2);
		    	
		    	objTotales.setPrimInterVolTotMod21(primInterVolTotMod21);
		    	objTotales.setPorcVidaVolTotMod21(porcVidaVolTotMod21);
		    	objTotales.setPorcNoVidaVolTotMod21(porcNoVidaVolTotMod21);
		    	objTotales.setRedPropiaVolTotMod21(redPropiaVolTotMod21);
		    	objTotales.setPrimInterNuevaMod21(primInterNuevaMod21);
		    	objTotales.setPorcVidaNuevaMod21(porcVidaNuevaMod21);
		    	objTotales.setPorcNoVidaNuevaMod21(porcNoVidaNuevaMod21);
		    	objTotales.setRedPropiaNuevaMod21(redPropiaNuevaMod21);
		    	objTotales.setTotPrimEntVolTotMod21(totPrimEntVolTotMod21);
		    	objTotales.setTotPrimEntNuevaMod21(totPrimEntNuevaMod21);
		
			
				//Calcular los campos del Modelo 1
				int totNumEmpAMedPer = 0;
				int totNumEmpBMedPer = 0;
				int totNumEmpCMedPer = 0;
				int totNumAfecMedPer = 0;
				int totNumNoAfecMedPer = 0;
				double totHorasMedPer = 0.0;
				double totGastoMedPer = 0.0;
				double primInterSedeMod1 = 0.0;
				
				for(int i=0;i<listaMod1MedPer.size();i++){
		    		P06B36T00Datatype objMod1MedPer = (P06B36T00Datatype)listaMod1MedPer.get(i);
		    		
		    		totHorasMedPer += P06BUtil.convertDouble(objMod1MedPer.getHoras());
		    		totGastoMedPer += P06BUtil.convertDouble(objMod1MedPer.getGasto());
		    		totNumEmpAMedPer += P06BUtil.convertInt(objMod1MedPer.getNumperA());
					totNumEmpBMedPer += P06BUtil.convertInt(objMod1MedPer.getNumperB());
					totNumEmpCMedPer += P06BUtil.convertInt(objMod1MedPer.getNumperC());
					totNumAfecMedPer += P06BUtil.convertInt(objMod1MedPer.getNumAfec());
					totNumNoAfecMedPer += P06BUtil.convertInt(objMod1MedPer.getNumNoAfec());
		    	}
		    	
		    	totHorasMedPer = P06BUtil.redondear(totHorasMedPer, 2);
		    	totGastoMedPer = P06BUtil.redondear(totGastoMedPer, 2);
		    	
		    	objTotales.setTotNumEmpAMedPer(totNumEmpAMedPer);
		    	objTotales.setTotNumEmpBMedPer(totNumEmpBMedPer);
		    	objTotales.setTotNumEmpCMedPer(totNumEmpCMedPer);
		    	objTotales.setTotNumAfecMedPer(totNumAfecMedPer);
		    	objTotales.setTotNumNoAfecMedPer(totNumNoAfecMedPer);
		    	objTotales.setTotHorasMedPer(totHorasMedPer);
		    	objTotales.setTotGastoMedPer(totGastoMedPer);
		    				
				//Calcular los totales del apartado sucursales del Modelo 1
				int totAfecSucurMod1 = 0;
				int totNoAfecSucurMod1 = 0;
				double totPrimSucurMod1 = 0.0;
				for(int i=0;i<listaObjs46Mod1Sucur.size();i++){
		    		P06B46T00Datatype objSucurMod1 = (P06B46T00Datatype)listaObjs46Mod1Sucur.get(i);
		    		
		    		totAfecSucurMod1 += P06BUtil.convertInt(objSucurMod1.getNumAfec());
		    		totNoAfecSucurMod1 += P06BUtil.convertInt(objSucurMod1.getNumNoAfec());
		    		totPrimSucurMod1 += P06BUtil.convertDouble(objSucurMod1.getPrimas());
		    	}
		    	totPrimSucurMod1 = P06BUtil.redondear(totPrimSucurMod1, 2);
		    	primInterSedeMod1 = P06BUtil.redondear((primInterVolTotMod21 - totPrimSucurMod1),2);
		    	
		    	objTotales.setTotAfecSucurMod1(totAfecSucurMod1);
		    	objTotales.setTotNoAfecSucurMod1(totNoAfecSucurMod1);
		    	objTotales.setTotPrimSucurMod1(totPrimSucurMod1);
		    	objTotales.setPrimInterSedeMod1(primInterSedeMod1);
		    	objTotales.setTotNumSucurMod1(listaObjs46Mod1Sucur.size());
		    	
		    	
		    	//objDECModelos.setObjTotales(objTotales);
		    	
			}
		}catch(Exception e){
			P06BLog.send(0,"P06BCalcTotDEC","calcTotalesDEC: Error calculando los totales y campos calculados de la DEC. ERROR: "+e.getMessage());
			
			return new P06BDECTotales12jun2010();
		}
		return objTotales;
		
		
   	}

}
